﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Diagnostics;

namespace Art_of_War
{
    class GrafikInformationen
    {
        #region Variablendeklarierung

        //int basenzahl;
        private List<Basis> basisliste;

        AktuelleSpielfeldwerte aktuelleSpielfeldwerte;
        LevelEinstellungen aktuellelevelsettings;
        PictureBox picbox;

        Spiel spiel;
        #endregion

        #region Konstruktor
        public GrafikInformationen (LevelEinstellungen levelsettings, Spiel spiel, PictureBox picbox )
        {
            this.aktuellelevelsettings = levelsettings;

            this.picbox = picbox;

            picbox.Size = new Size((int)levelsettings.spielfeldgroesse.x, (int)levelsettings.spielfeldgroesse.y);
            picbox.BackgroundImage = Resource1.dark_green_grass_texture_other;
            picbox.Image = Draw();


            
            //this.basenzahl = levelsettings.Basenzahl;
            //this.basisliste = levelsettings.basisliste;

            this.spiel = spiel;
            this.spiel.grafikdatenunterwegslisteupdate += new EventHandler<GrafikEventArgs>(spiel_grafikdatenunterwegslisteupdate);

        }
        #endregion

        #region Methoden
        private Image Draw()
        {

            
            Bitmap bmp = new Bitmap(950, 1000);
            Graphics g = Graphics.FromImage(bmp);

            for (int i = 0; i< aktuellelevelsettings.Basenzahl; i++)
            {
                var basis=aktuellelevelsettings.basisliste[i];

                
                int verbindungszahl = basis.verbindungen.Length;
                for(int j=0; j< verbindungszahl;j++)
                {
                    //Draw Line von Endbasis
                    Point p1 = new Point((int)(aktuellelevelsettings.basisliste[basis.verbindungen[j]].position.x * picbox.Width), 
                                         (int)(aktuellelevelsettings.basisliste[basis.verbindungen[j]].position.y * picbox.Height));
                    //zu Anfangsbasis
                    Point p2 = new Point((int)(basis.position.x * picbox.Width), (int)(basis.position.y * picbox.Height));
                    g.DrawLine(new Pen(Color.Orange, 5), p1, p2);
                }
                

            }

            // Basen zeichnen
            for (int i = 0; i < aktuellelevelsettings.Basenzahl; i++)
            {
                var basis = aktuellelevelsettings.basisliste[i];
                int basesize = basis.Basengroesse*8+40;
                

                switch (basis.spielerzugehoerigkeit)
                {
                    case zugehoerigkeit.rot:
                        g.DrawImage(Resource1.base1_2, basis.position.x * picbox.Width - basesize / 2, basis.position.y * picbox.Height - basesize / 2, basesize, basesize);
                    //    g.DrawImage(Resource1.mobat_red, einheit.positionx * picbox.Width - 40, einheit.positiony * picbox.Height - 25, 80, 50);
                        break;
                    case zugehoerigkeit.blau: g.DrawImage(Resource1.base2_2, basis.position.x * picbox.Width - basesize / 2, basis.position.y * picbox.Height - basesize / 2, basesize, basesize);
                        break;
                    default: g.DrawImage(Resource1.base1_0, basis.position.x * picbox.Width - basesize / 2, basis.position.y * picbox.Height - basesize / 2, basesize, basesize);
                        break;
                }
            }



            for (int i = 0; i < aktuellelevelsettings.Basenzahl; i++)
            {
                var basis = aktuellelevelsettings.basisliste[i];
                int basesize = (basis.Basengroesse*8+30)/2;

                
                //Einheitenwerte über den Basen zeichnen
                StringFormat stringformat = new StringFormat();
                stringformat.Alignment = StringAlignment.Center;
                stringformat.LineAlignment = StringAlignment.Center;

                g.DrawString(((int)basis.einheiten).ToString(), SystemFonts.DefaultFont, Brushes.Black, basis.position.x * picbox.Width+1, basis.position.y * picbox.Height+1, stringformat);
                g.DrawString(((int)basis.einheiten).ToString(), SystemFonts.DefaultFont, Brushes.White, basis.position.x * picbox.Width, basis.position.y * picbox.Height, stringformat);

                //Zeichnet die Basisnummer hin
                g.DrawString("["+basis.ID.ToString()+"]", SystemFonts.DefaultFont, Brushes.Black, basis.position.x * picbox.Width + basesize+1, basis.position.y * picbox.Height+basesize+1, stringformat);
                g.DrawString("[" + basis.ID.ToString() + "]", SystemFonts.DefaultFont, Brushes.White, basis.position.x * picbox.Width + basesize, basis.position.y * picbox.Height + basesize, stringformat);

            }

            //Zeichnet die Einheiten, die Unterwegs sind
            if (aktuelleSpielfeldwerte != null)
            {
                StringFormat stringformat = new StringFormat();
                stringformat.Alignment = StringAlignment.Center;
                stringformat.LineAlignment = StringAlignment.Center;

                for (int i = 0; i < aktuelleSpielfeldwerte.Unterwegsliste.Count; i++)
                {

                    var einheit = aktuelleSpielfeldwerte.Unterwegsliste[i];
                    float angle = (float)((57.29*Math.Atan2(einheit.speedy,einheit.speedx))+90);
                    //g.TranslateTransform(einheit.positionx*picbox.Width+40, einheit.positiony*picbox.Height+25);
                    //g.RotateTransform(angle);
                    Debug.WriteLine("Das ist der winkel: " + angle);
                    switch (einheit.spielerzugehoerigkeit)
                    {
                        case zugehoerigkeit.rot:
                            g.DrawImage(Resource1.mobat_red, einheit.positionx * picbox.Width-40, einheit.positiony * picbox.Height-25, 80, 50);
                            //g.FillRectangle(Brushes.Red, einheit.positionx * picbox.Width, einheit.positiony * picbox.Height, 8, 4);
                            break;
                        case zugehoerigkeit.blau:
                            g.DrawImage(Resource1.mobat_top, einheit.positionx * picbox.Width-40, einheit.positiony * picbox.Height-25, 80, 50);
                            break;
                    }

                    g.DrawString(((int)einheit.anzahl).ToString(), SystemFonts.DefaultFont, Brushes.Black, einheit.positionx * picbox.Width, einheit.positiony * picbox.Height, stringformat);
                    g.DrawString(((int)einheit.anzahl).ToString(), SystemFonts.DefaultFont, Brushes.White, einheit.positionx * picbox.Width, einheit.positiony * picbox.Height, stringformat);
                    //g.TranslateTransform(-(einheit.positionx * picbox.Width + 40), -(einheit.positiony * picbox.Height + 25));
                    //g.RotateTransform(-angle);
                }
            }


            return bmp;
        }

        void spiel_grafikdatenunterwegslisteupdate(object sender, GrafikEventArgs e)
        {
            this.aktuelleSpielfeldwerte=e.actwerte;
            this.aktuellelevelsettings=e.level;
            //Neuzeichnen der PictureBox aus Form1 nach jedem Zyklus
            picbox.Image = Draw();
        }
        #endregion
    }
}
